% FIGURE 2.2.2
      function X = DLLSQR(A,M,N,B)
%
%  FUNCTION DLLSQR SOLVES THE LINEAR LEAST SQUARES PROBLEM
%
%          MINIMIZE  2-NORM OF (A*X-B)
%
%
%  ARGUMENTS
%
%             ON INPUT                          ON OUTPUT
%             --------                          ---------
%
%    A      - THE M BY N MATRIX.
%
%    M      - THE NUMBER OF ROWS IN A.
%
%    N      - THE NUMBER OF COLUMNS IN A.
%
%    X      -                                   AN N-VECTOR CONTAINING
%                                               THE LEAST SQUARES
%                                               SOLUTION.
%
%    B      - THE RIGHT HAND SIDE M-VECTOR.
%
%-----------------------------------------------------------------------
%                              EPS = MACHINE FLOATING POINT RELATIVE
%                                    PRECISION
% *****************************
      EPS = eps;
% *****************************
%                              AMAX = MAXIMUM ELEMENT OF A
      AMAX = 0.0;
      for I=1:M
      for J=1:N
         AMAX = max(AMAX,abs(A(I,J)));
      end
      end
      ERRLIM = 1000*EPS*AMAX;
%                              REDUCTION TO ROW ECHELON FORM
      [A,B,PIVOT,NPIVOT] = REDQ(A,M,N,B,ERRLIM);
%                              CAUTION USER IF SOLUTION NOT UNIQUE.
      if (NPIVOT ~= N)
         disp(' NOTE: SOLUTION IS NOT UNIQUE ')
      end
%                              ASSIGN VALUE OF ZERO TO NON-PIVOT
%                              VARIABLES.
      for K=1:N
         X(K) = 0.0;
      end
%                              SOLVE FOR PIVOT VARIABLES USING BACK
%                              SUBSTITUTION.
      for I=NPIVOT:-1:1
         L = PIVOT(I);
         SUM = 0.0;
         for K=L+1:N
            SUM = SUM + A(I,K)*X(K);
         end
         X(L) = (B(I)-SUM)/A(I,L);
      end
