% FIGURE 3.4.2
      function A = HESSH(A,N)
      if (N <= 2)
         return
      end
%                              USE HOUSEHOLDER TRANSFORMATIONS TO
%                              REDUCE A TO UPPER HESSENBERG FORM
      for I=2:N-1
%                              CHOOSE UNIT N-VECTOR W (WHOSE FIRST
%                              I-1 COMPONENTS ARE ZERO) SUCH THAT WHEN
%                              COLUMN I-1 IS PREMULTIPLIED BY
%                              H = I - 2W*W^T, COMPONENTS I+1 THROUGH
%                              N ARE ZEROED.
         W = CALW(A(1:N,I-1),N,I);
%                              PREMULTIPLY A BY H = I - 2W*W^T
         for K=I-1:N
            WTA = 0.0;
            for J=I:N
               WTA = WTA + W(J)*A(J,K);
            end
            TWOWTA = 2*WTA;
            for J=I:N
               A(J,K) = A(J,K) - TWOWTA*W(J);
            end
         end
%                              POSTMULTIPLY A BY H = I - 2W*W^T
         for K=1:N
            ATW = 0.0;
            for J=I:N
               ATW = ATW + A(K,J)*W(J);
            end
            TWOATW = 2*ATW;
            for J=I:N
               A(K,J) = A(K,J) - TWOATW*W(J);
            end
         end
      end
