% FIGURE 2.3.1
      function W = CALW(A,M,I)
%                              SUBROUTINE CALW CALCULATES A UNIT
%                              M-VECTOR W (WHOSE FIRST I-1 COMPONENTS
%                              ARE ZERO) SUCH THAT PREMULTIPLYING THE
%                              VECTOR A BY H = I - 2W*W^T ZEROES
%                              COMPONENTS I+1 THROUGH M.
      S = 0.0;
      for J=I:M
         S = S + A(J)^2;
         W(J) = A(J);
      end
      if (A(I) >= 0.0)
         BETA = sqrt(S);
      else
         BETA = -sqrt(S);
      end
      W(I) = A(I) + BETA;
      TWOALP = sqrt(2*BETA*W(I));
%                              TWOALP=0 ONLY IF A(I),...,A(M) ARE ALL
%                              ZERO.  IN THIS CASE, RETURN WITH W=0
      if (TWOALP == 0.0)
         return
      end
%                              NORMALIZE W
      for J=I:M
         W(J) = W(J)/TWOALP;
      end
