% FIGURE 4.6.2
      function [CMIN,X] = DTRAN(WCAP,SREQ,COST,NW,NS)
%
%  FUNCTION DTRAN SOLVES THE TRANSPORTATION PROBLEM
%
%    MINIMIZE    CMIN = COST(1,1)*X(1,1) + ... + COST(NW,NS)*X(NW,NS)
%
%    WITH X(1,1),...,X(NW,NS) NONNEGATIVE, AND
%
%          X(1,1) + ... + X(1,NS)   <=  WCAP(1)
%             .              .            .
%             .              .            .
%          X(NW,1)+ ... + X(NW,NS)  <=  WCAP(NW)
%          X(1,1) + ... + X(NW,1)    =  SREQ(1)
%             .              .            .
%             .              .            .
%          X(1,NS)+ ... + X(NW,NS)   =  SREQ(NS)
%
%  ARGUMENTS
%
%             ON INPUT                          ON OUTPUT
%             --------                          ---------
%
%    WCAP   - A VECTOR OF LENGTH NW CONTAINING
%             THE WAREHOUSE CAPACITIES.
%
%    SREQ   - A VECTOR OF LENGTH NS CONTAINING
%             THE STORE REQUIREMENTS.
%
%    COST   - THE NW BY NS COST MATRIX. COST(I,J)
%             IS THE PER UNIT COST TO SHIP FROM
%             WAREHOUSE I TO STORE J.
%
%    NW     - THE NUMBER OF WAREHOUSES.
%
%    NS     - THE NUMBER OF STORES.
%
%    CMIN   -                                   THE TOTAL COST OF THE
%                                               OPTIMAL ROUTING.
%
%    X      -                                   AN NW BY NS MATRIX
%                                               CONTAINING THE OPTIMAL
%                                               ROUTING.  X(I,J) UNITS
%                                               SHOULD BE SHIPPED FROM
%                                               WAREHOUSE I TO STORE J.
%
%-----------------------------------------------------------------------
      global NWg
      global NSg
      NWg = NW;
      NSg = NS;
      M = NW+NS;
      N = NW*NS+NW+NS;
%                              LOAD WAREHOUSE CAPACITIES AND STORE
%                              REQUIREMENTS INTO B VECTOR
      for I=1:NW
         B(I) = WCAP(I);
      end
      for I=1:NS
         B(NW+I) = SREQ(I);
      end
%                              FIRST NW*NS ENTRIES IN C ARE -COST(I,J).
%                              NEGATIVE SIGN PRESENT BECAUSE WE WANT
%                              TO MINIMIZE COST
      K = 0;
      CNORM = 0.0;
      for I=1:NW
      for J=1:NS
         K = K+1;
         C(K) = -COST(I,J);
         CNORM = max(CNORM,abs(C(K)));
      end
      end
%                              NEXT NW COSTS ARE ZERO, CORRESPONDING
%                              TO WAREHOUSE CAPACITY SLACK VARIABLES
      for I=1:NW
         K = K+1;
         C(K) = 0.0;
      end
%                              LAST NS COSTS ARE LARGE AND NEGATIVE,
%                              CORRESPONDING TO "ARTIFICIAL WAREHOUSE"
%                              TRANSPORTATION COSTS
      ALPHA = 2*CNORM;
      for I=1:NS
         K = K+1;
         C(K) = -ALPHA;
      end
%                              USE REVISED SIMPLEX METHOD TO SOLVE
%                              TRANSPORTATION PROBLEM
      [P,XSOL,Y] = DLPRV('DTRAN2',B,C,N,M);
%                              IF ANY ARTIFICIAL VARIABLES LEFT, THERE
%                              IS NO FEASIBLE SOLUTION
      for I=1:NS
         K = N-NS+I;
         if (XSOL(K) ~= 0.0)
            disp ('***** NO FEASIBLE SOLUTION *****')
            break
         end
      end
%                              FORM OPTIMAL ROUTING MATRIX, X
      CMIN = -P;
      K = 0;
      for I=1:NW
      for J=1:NS
         K = K+1;
         X(I,J) = XSOL(K);
      end
      end
 
