% FIGURE 3.3.4
      function A = HESSQ(A,N)
      if (N <= 2)
         return
      end
%                              USE GIVENS ROTATIONS TO REDUCE A
%                              TO UPPER HESSENBERG FORM
      for I=2:N-1
         for J=I+1:N
            if (A(J,I-1) == 0.0)
              continue
            end
            DEN = sqrt(A(I,I-1)^2+A(J,I-1)^2);
            C = A(I,I-1)/DEN;
            S = A(J,I-1)/DEN;
%                              PREMULTIPLY BY Qij^T
            for K=I-1:N
               PIK = C*A(I,K) + S*A(J,K);
               PJK =-S*A(I,K) + C*A(J,K);
               A(I,K) = PIK;
               A(J,K) = PJK;
            end
%                              POSTMULTIPLY BY Qij
            for K=1:N
               BKI = C*A(K,I) + S*A(K,J);
               BKJ =-S*A(K,I) + C*A(K,J);
               A(K,I) = BKI;
               A(K,J) = BKJ;
            end
         end
      end
