% FIGURE 2.3.1
      function [A,B,PIVOT,NPIVOT] = REDH(A,M,N,B,ERRLIM)
%                              USE HOUSEHOLDER TRANSFORMATIONS TO
%                              REDUCE A TO ROW ECHELON FORM
      I = 1;
      for L=1:N
%                              USE PIVOT A(I,L) TO KNOCK OUT ELEMENTS
%                              I+1 TO M IN COLUMN L.
         if (I+1 <= M)
%                              CHOOSE UNIT M-VECTOR W (WHOSE FIRST
%                              I-1 COMPONENTS ARE ZERO) SUCH THAT WHEN
%                              COLUMN L IS PREMULTIPLIED BY
%                              H = I - 2W*W^T, COMPONENTS I+1 THROUGH
%                              M ARE ZEROED.
            W = CALW(A(1:M,L),M,I);
%                              PREMULTIPLY A BY H = I - 2W*W^T
            for K=L:N
               WTA = 0.0;
               for J=I:M
                  WTA = WTA + W(J)*A(J,K);
               end
               TWOWTA = 2*WTA;
               for J=I:M
                  A(J,K) = A(J,K) - TWOWTA*W(J);
               end
            end
%                              PREMULTIPLY B BY H = I - 2W*W**T
            WTA = 0.0;
            for J=I:M
               WTA = WTA + W(J)*B(J);
            end
            TWOWTA = 2*WTA;
            for J=I:M
               B(J) = B(J) - TWOWTA*W(J);
            end
         end
%                              PIVOT A(I,L) IS NONZERO AFTER PROCESSING
%                              COLUMN L--MOVE DOWN TO NEXT ROW, I+1
         if (abs(A(I,L)) <= ERRLIM)
            A(I,L) = 0.0;
         end
         if (A(I,L) ~= 0.0)
            NPIVOT = I;
            PIVOT(NPIVOT) = L;
            I = I+1;
            if (I > M)
               return
            end
         end
      end
